(
	-- Checker Texture

    struct AMGData 
	(
		fn GetUUID mtl context = 
		(
			"3f333e0c-f983-4c49-8855-09775cc26a7b"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode

			if mtl.map1 != undefined and mtl.map1enabled do 
			(
				append res #("Color1", mtl.map1, out)
				append res #("Alpha1", mtl.map1, "alpha")
			)
			if mtl.map2 != undefined and mtl.map2enabled do 
			(
				append res #("Color2", mtl.map2, out)
				append res #("Alpha2", mtl.map2, "alpha")
			)

			if mtl.mask != undefined and mtl.maskEnabled do 
				append res #("Blend", mtl.mask, "resultFloat")

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			-- In "percent", so divide by 100....
			append res #("Blend",      mtl.mixAmount / 100.0)

			append res #("Color1", mtl.color1)
			append res #("Color2", mtl.color2)
			append res #("Alpha1", 1.0)
			append res #("Alpha2", 1.0)

			if (mtl.maskEnabled) do (
				append res #("UseCurve",   mtl.useCurve)
				append res #("Low",        mtl.lower)
				append res #("High",       mtl.upper)
			)
	
 			res
		)
	)
	AMGData()
)
